<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html"/>
<xsl:variable name="displaylevel"><xsl:if test="count(/uop/displaylevel)>0"><xsl:value-of select="/uop/displaylevel"/></xsl:if><xsl:if test="count(/uop/displaylevel)=0">4</xsl:if></xsl:variable>
<xsl:variable name="resname"><xsl:value-of select="//resistance-name"/></xsl:variable>

<!-- Режим с разделами -->
<xsl:variable name="withpartition">1</xsl:variable>
<xsl:variable name="gsmswitch"><xsl:value-of select="//gsm-switch"/></xsl:variable>
<xsl:variable name="multipanelmode"><xsl:value-of select="//multipanel-enable"/></xsl:variable>
<xsl:variable name="hidetmkeys"><xsl:value-of select="//hidekeys"/></xsl:variable>
<xsl:variable name="resistance-mode"><xsl:if test="count(/uop/lowlevel-om)>0">1</xsl:if><xsl:if test="count(/uop/lowlevel-om)=0">0</xsl:if></xsl:variable>
<xsl:variable name="termohigh"><xsl:if test="count(//ds1820/@highrelay)>0"><xsl:value-of select="//ds1820/@highrelay"/></xsl:if></xsl:variable>
<xsl:variable name="termolow"><xsl:if test="count(//ds1820/@lowrelay)>0"><xsl:value-of select="//ds1820/@lowrelay"/></xsl:if></xsl:variable>
<xsl:variable name="termohigh1"><xsl:if test="count(//ds1820/@highrelay)>0"><xsl:value-of select="//ds1820/@highrelay - 3"/></xsl:if></xsl:variable>
<xsl:variable name="termolow1"><xsl:if test="count(//ds1820/@lowrelay)>0"><xsl:value-of select="//ds1820/@lowrelay - 3"/></xsl:if></xsl:variable>

<xsl:template match="uop">
<HTML>
<HEAD>
<TITLE>Устройство <xsl:value-of select="@id"/></TITLE>
</HEAD>
<BODY>

<div style="position:absolute;font-size:190px;font-family:Times New Roman;color:#F0F0FF;z-index:-1">Proxyma</div>

<h1 align="center">

    <xsl:if test="@id!='tmpl'">Устройство <xsl:value-of select="@id"/>.</xsl:if>
    <xsl:if test="@id='tmpl'"></xsl:if>
    Тип <xsl:value-of select="@type"/>
    <xsl:if test="count(x10devs/x10dev)>0">
        &#160;Исп. 10
    </xsl:if>
    <xsl:if test="count(enocean-devs/enodev)>0">
        &#160;Поддержка Enocean
    </xsl:if>
    .&#160;
    <xsl:if test="@version!=''">
    V&#160;<xsl:value-of select="@version"/>
    </xsl:if>
</h1>

<h2 align="center"><font color="#0000ff"><xsl:value-of select="description"/></font></h2>

<xsl:if test="count(big-description)>0">
    <xsl:if test="count(big-description/pre)>0">
        <pre>
        <xsl:value-of select="big-description/pre"/>
        </pre>
    </xsl:if>
    <xsl:if test="count(big-description/pre)=0">
        <xsl:value-of select="big-description"/>
    </xsl:if>
</xsl:if>

<h3 align="center">Общие настройки</h3>
<table border="1" cellpadding="2" cellspacing="2" width="90%" align="center">
    <xsl:if test="count(passw)>0">
        <tr>
        <td align="left">Пароль доступа для внешнего управления, конфигурирования</td>
        <td align="right"><xsl:value-of select="passw"/></td>
        </tr>
    </xsl:if>
    <tr>
        <td align="left">Доступ к конфигурации по паролю</td>
        <xsl:if test="/uop[@protect='1']">
            <td align="right">Включен</td>
        </xsl:if>
        <xsl:if test="count(/uop[@protect])=0 or /uop[@protect='0']">
            <td align="right"><font color="#ff0000"><b>Выключен</b></font></td>
        </xsl:if>
    </tr>
    <!-- tr>
        <td align="left">Режим совместимости</td>
        <td align="right">Виста-501</td>
    </tr -->

    <xsl:if test="count(/uop/system-partition)>0">
        <tr>
            <td align="left">Номер раздела для системных извещений</td>
            <td align="right"><font color="#ff0000"><b><xsl:value-of select="/uop/system-partition"/>&#160;</b></font></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(//multipanel)>0 and count(//multipanel-enable)>0">
        <xsl:if test="$multipanelmode=1">
           <tr>
               <td align="left">Передавамый номер устройства зависит от номера раздела шлейфа.
               Для первого раздела он совпадает с основным, для второго - на 1 больше и т.д.</td>
               <td align="right">(кроме SMS-извещений!)</td>
           </tr>
        </xsl:if>
    </xsl:if>

    <xsl:if test="$displaylevel>2">
        <xsl:if test="$resistance-mode=1">
            <xsl:if test="count(lowlevel-om)>0">
               <xsl:call-template name="table_resistance">
                   <xsl:with-param name="txt" select="'Минимально допустимое сопротивление шлейфа с учетом 10% точности'"/>
                   <xsl:with-param name="res" select="lowlevel-om"/>
               </xsl:call-template>
            </xsl:if>
            <xsl:if test="count(highlevel-om)>0">
               <xsl:call-template name="table_resistance">
                   <xsl:with-param name="txt" select="'Максимально допустимое сопротивление шлейфа с учетом 10% точности'"/>
                   <xsl:with-param name="res" select="highlevel-om"/>
               </xsl:call-template>
            </xsl:if>
            <xsl:if test="count(fire-short-om)>0">
               <xsl:call-template name="table_resistance">
                   <xsl:with-param name="txt" select="'Сопротивление КЗ пожарного шлейфа не более'"/>
                   <xsl:with-param name="res" select="fire-short-om"/>
               </xsl:call-template>
            </xsl:if>
            <xsl:if test="count(fire-break-om)>0">
               <xsl:call-template name="table_resistance">
                   <xsl:with-param name="txt" select="'Сопротивление обрыва пожарного шлейфа не менее'"/>
                   <xsl:with-param name="res" select="fire-break-om"/>
               </xsl:call-template>
            </xsl:if>
        </xsl:if>

        <xsl:if test="count(drifts/drift)>0">
           <!--
           <xsl:call-template name="table_resistance">
               <xsl:with-param name="txt" select="'Предельно допустимый уход сопротивления шлейфа между 50 мсек измерениями (мгновенный дрейф)'"/>
               <xsl:with-param name="res" select="drifts/drift"/>
           </xsl:call-template>
           -->
           <tr>
           <td align="left">Предельно допустимый уход сопротивления шлейфа между 50 мсек измерениями (мгновенный дрейф)</td>
           <td align="right"><xsl:value-of select="drifts/drift"/>%&#160;</td>
           </tr>
        </xsl:if>
        <xsl:if test="count(drifts/slowdrift-time)>0">
        <tr>
        <td align="left">Период измерений медленного дрейфа, секунд</td>
        <td align="right"><xsl:value-of select="drifts/slowdrift-time"/></td>
        </tr>
            <xsl:if test="count(drifts/slowdrift)>0">
                <!--
                <xsl:variable name="dtxt">Предельно допустимый уход сопротивления шлейфа в течение <xsl:value-of select="drifts/slowdrift-time"/> сек (медленный дрейф)</xsl:variable>
                <xsl:call-template name="table_resistance">
                    <xsl:with-param name="txt" select="$dtxt"/>
                    <xsl:with-param name="res" select="drifts/slowdrift"/>
                </xsl:call-template>
                -->
            </xsl:if>
           <tr>
           <td align="left">Предельно допустимый уход сопротивления шлейфа в течение <xsl:value-of select="drifts/slowdrift-time"/> сек (медленный дрейф)</td>
           <td align="right"><xsl:value-of select="drifts/slowdrift"/>%&#160;</td>
           </tr>
        </xsl:if>
        <xsl:if test="count(breaktime)>0">
        <tr>
        <td align="left">Время констатации нарушения шлейфа, мсек</td>
        <td align="right"><xsl:value-of select="breaktime"/></td>
        </tr>
        </xsl:if>
        <xsl:if test="count(loop-settle-time)>0">
        <tr>
        <td align="left">Время констатации нормального сопротивления шлейфа при взятии шлейфа под охрану, мсек</td>
        <td align="right"><xsl:value-of select="loop-settle-time"/></td>
        </tr>
        </xsl:if>

        <xsl:if test="count(loop-stabilization)>0">
        <tr>
        <td align="left">Максимальное время стабилизации состояния проводных зон после включения питания ("выход на режим"), сек</td>
        <td align="right"><xsl:value-of select="loop-stabilization"/></td>
        </tr>
        </xsl:if>
    </xsl:if>
    <xsl:if test="count(delay-for-out)>0">
    <tr>
    <td align="left">Время задержки на выход, сек</td>
    <td align="right"><xsl:value-of select="delay-for-out"/></td>
    </tr>
    </xsl:if>
    <xsl:if test="count(delay-for-in)>0">
    <tr>
    <td align="left">Время задержки на вход, сек</td>
    <td align="right"><xsl:value-of select="delay-for-in"/></td>
    </tr>
    </xsl:if>

    <xsl:if test="count(sound/entry-sound)>0">
    <tr>
    <td align="left">Звуковой сигнал при входе (до снятия с охраны или констатации тревоги)</td>
    <td align="right"><font color="#ff0000">Разрешен</font></td>
    </tr>
    </xsl:if>

    <xsl:if test="count(entry-siren)>0">
    <tr>
    <td align="left">Включить программу тревоги сирены, если после тревоги проникновения (сработка зоны входа) и отмене сработки раздел не был снят с охраны</td>
    <td align="right"><font color="#ff0000">Да</font></td>
    </tr>
    </xsl:if>

    <xsl:if test="count(take-after-alarm-time)>0">
    <tr>
    <td align="left">Время задержки автоматического взятия шлейфов под охрану после тревоги, сек</td>
    <td align="right"><xsl:value-of select="take-after-alarm-time"/></td>
    </tr>
    </xsl:if>

    <xsl:if test="count(three-breaks-period)>0">
    <tr>
    <td align="left">Период ограничения 3-х срабатываний, мин</td>
    <td align="right"><xsl:value-of select="three-breaks-period"/></td>
    </tr>
    </xsl:if>

    <tr>
    <td align="left">Периодичность повтора несброшенных тревог, часы</td>
        <xsl:if test="count(alarm-repeat-period)>0">
            <td align="right"><xsl:value-of select="alarm-repeat-period"/></td>
        </xsl:if>
        <xsl:if test="count(alarm-repeat-period)=0">
            <td align="left">&#160;&#160;Не повторяются</td>
        </xsl:if>
    </tr>

    <xsl:if test="count(boot-mode)>0">
    <xsl:variable name="bmode"><xsl:value-of select="boot-mode"/></xsl:variable>
    <tr>
    <td align="left">Действия после включения устройства</td>
    <td>&#160;
        <xsl:if test="count(boot-mode-desc)>0">
            <xsl:value-of select="//boot-mode-desc/code[@id=$bmode]"/>
        </xsl:if>
        <xsl:if test="count(boot-mode-desc)=0">
            <xsl:choose>
               <xsl:when test="$bmode='0'">Все шлейфы сняты с охраны</xsl:when>
               <xsl:when test="$bmode='1'">Взять под охрану пожарные и тревожные шлейфы</xsl:when>
               <xsl:when test="$bmode='2'">Взять под охрану шлейфы, взятые под охрану до перезагрузки</xsl:when>
            </xsl:choose>
        </xsl:if>
    </td>
    </tr>
    </xsl:if>

    <tr>
        <td align="left">Постановка под охрану при отсутствии связи</td>
        <td align="right">
        <font color="#ff0000"><b>
            <xsl:if test="count(/uop/lock-arm-when-nocomm)>0">
                        <xsl:if test="count(/uop/lock-arm-when-nocomm[@value='Y'])>0">Запрещена</xsl:if>
                        <xsl:if test="count(/uop/lock-arm-when-nocomm[@value='N'])>0">Разрешена</xsl:if>
            </xsl:if>
            <xsl:if test="count(/uop/lock-arm-when-nocomm)=0">Разрешена по умолчанию</xsl:if>
        </b></font>
        </td>
    </tr>

    <tr>
    <td align="left">Постановка под охрану, если нет напряжения сети 220 В</td>
    <td align="right"><font color="#ff0000"><b>
        <xsl:if test="count(/uop/arm220only)>0">
            <xsl:if test="count(/uop/arm220only[@value='N'])>0">Разрешена</xsl:if>
            <xsl:if test="count(/uop/arm220only[@value='Y'])>0">Запрещена</xsl:if>
        </xsl:if>
        <xsl:if test="count(/uop/arm220only)=0">Разрешена по умолчанию</xsl:if>
        </b></font>
    </td>
    </tr>

    <xsl:if test="count(@arm-with-tamper)>0">
    <tr>
    <td align="left">При постановке под охрану не учитывается состояние тампера датчика</td>
    <td align="right"><font color="#ff0000"><b>Да</b></font>&#160;</td>
    </tr>
    </xsl:if>

    <xsl:if test="count(fire-reset-mode)>0">
    <xsl:variable name="rmode"><xsl:value-of select="fire-reset-mode"/></xsl:variable>
    <tr>
    <td align="left">Необходимость сброса пожарных шлейфов отключением питания</td>
    <td>&#160;
        <xsl:if test="count(fire-reset-desc)>0">
            <xsl:value-of select="//fire-reset-desc/code[@id=$rmode]"/>
        </xsl:if>
        <xsl:if test="count(fire-reset-desc)=0">
            <xsl:choose>
               <xsl:when test="$rmode='0'">Не сбрасывать</xsl:when>
               <xsl:when test="$rmode='1'">Сбросить после снятия тревоги</xsl:when>
               <xsl:when test="$rmode='2'">Сбросить после возникновения тревоги</xsl:when>
            </xsl:choose>
        </xsl:if>
    </td>
    </tr>
    </xsl:if>
    <xsl:if test="count(fire-off-delay)>0">
    <tr>
    <td align="left">Задержка сброса (отключения питания) пожарного шлейфа после тревоги, сек.</td>
    <td align="right"><xsl:value-of select="fire-off-delay"/></td>
    </tr>
    </xsl:if>
    <xsl:if test="count(fire-off-time)>0">
    <tr>
    <td align="left">Длительность сброса (отключения питания) пожарного шлейфа, сек.</td>
    <td align="right"><xsl:value-of select="fire-off-time"/></td>
    </tr>
    </xsl:if>


    <xsl:if test="$displaylevel>5">
        <xsl:if test="count(lock/min-time)>0">
        <tr>
        <td align="left">Минимальное время нажатия кнопки замка (замок срабатывает при отпускании кнопки), мсек</td>
        <td align="right"><xsl:value-of select="lock/min-time"/></td>
        </tr>
        </xsl:if>
        <xsl:if test="count(lock/max-time)>0">
        <tr>
        <td align="left">Максимально допустимое время нажатия кнопки замка, мсек</td>
        <td align="right"><xsl:value-of select="lock/max-time"/></td>
        </tr>
        </xsl:if>
        <xsl:if test="count(detail/min-time)>0">
        <tr>
        <td align="left">Минимальное время нажатия кнопки "Контроль наряда", мсек</td>
        <td align="right"><xsl:value-of select="detail/min-time"/></td>
        </tr>
        </xsl:if>
        <xsl:if test="count(detail/max-time)>0">
        <tr>
        <td align="left">Максимально допустимое время нажатия кнопки "Контроль наряда", мсек</td>
        <td align="right"><xsl:value-of select="detail/max-time"/></td>
        </tr>
        </xsl:if>
    </xsl:if>

    <!-- Телефонный план  -->
    <xsl:if test="count(phone-numbering-map)>0">
      <tr>
        <td align="left">Телефонный код страны</td><td align="right"><xsl:value-of select="phone-numbering-map/@country-code"/>&#160;</td>
      </tr>
      <tr>
        <td align="left">Набор межгорода внутри страны начинается цифрой</td><td align="right"><xsl:value-of select="phone-numbering-map/@icity"/>&#160;</td>
      </tr>
    </xsl:if>

    <xsl:if test="count(accu-check-time)>0">
        <tr>
          <td align="left">Периодичность проверки аккумулятора нагрузкой, минут<br/>0 - проверка аккумулятора отключена</td>
          <td align="right"><xsl:value-of select="accu-check-time/@value"/>&#160;</td>
        </tr>
    </xsl:if>

    <!-- Параметры отправки извещений -->
    <tr>
    <td align="left">Выполнять транслитерацию ответов на служебные SMS</td>
    <td align="right">
        <xsl:choose>
           <xsl:when test="sms[@replytranslit='1']">Да</xsl:when>
           <xsl:otherwise>Нет</xsl:otherwise>
        </xsl:choose>
    </td>
    </tr>

    <xsl:if test="sms[@inverse='1']">
        <tr>
        <td align="left">При отправке SMS номер устройства и время размещать в конце</td>
        <td align="right">Да</td>
        </tr>
    </xsl:if>

    <xsl:if test="count(sms/sms-attempts)>0">
        <tr>
        <td align="left">Количество попыток отправки SMS-извещений подряд по одному номеру получателя</td>
        <td align="right"><xsl:value-of select="sms/sms-attempts"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(sms/sms-rounds)>0">
        <tr>
        <td align="left">Количество проходов по всему списку номеров отправки SMS</td>
        <td align="right"><xsl:value-of select="sms/sms-rounds"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(sms/waittime)>0">
        <tr>
        <td align="left">Время ожидания подтверждения доставки SMS, сек.</td>
        <td align="right"><xsl:value-of select="sms/waittime"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(sms/sms-faults)>0">
        <tr>
        <td align="left">Направление доставки блокируется, если подряд не отправлено извещений SMS</td>
        <td align="right"><xsl:value-of select="sms/sms-faults"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(gsm-faults)>0">
        <tr>
        <td align="left">GSM канал блокируется, если подряд не отправлено извещений.
        Происходит переключение на другого оператора.
        </td>
        <td align="right"><xsl:value-of select="gsm-faults"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(gsm-csd-proto)>0">
        <tr>
        <td align="left">Формат CSD</td>
        <td align="left">
            <xsl:if test="count(gsm-csd-proto/@namea)>0">
                SIM A:&#160;<xsl:value-of select="gsm-csd-proto/@namea"/>&#160;&#160;&#160;&#160;&#160;
            </xsl:if>
            <xsl:if test="count(gsm-csd-proto/@nameb)>0">
                SIM B:&#160;<xsl:value-of select="gsm-csd-proto/@nameb"/><br/>
            </xsl:if>
        </td>
        </tr>
    </xsl:if>

    <xsl:if test="count(gsm-min-level)>0">
        <tr>
        <td align="left">Минимально допустимый уровень сигнала в канале GSM, дБ
        </td>
        <td align="right"><xsl:value-of select="gsm-min-level"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(gsm-gain-level)>0">
        <tr>
        <td align="left">Уровень усиления микрофонного входа GSM-модуля, дБ
        </td>
        <td align="right">+<xsl:value-of select="format-number(gsm-gain-level * 1.5 + 0.0001,'##.0')"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(min-active-settle-time)=0">
        <xsl:if test="count(gsm-settle-time)>0">
            <tr>
            <td align="left">Если канал GSM работает, проверять восстановление направления доставки через сек.
            </td>
            <td align="right"><xsl:value-of select="gsm-settle-time"/></td>
            </tr>
        </xsl:if>
    </xsl:if>

    <xsl:if test="count(gsm-sima-timer)>0">
        <tr>
        <td align="left">Если ППКОП оснащен двумя SIM-картами и произошло переключение на SIM-B, принудительно
        проверить возможность возврата к SIM-A через мин.
        </td>
        <td align="right"><xsl:value-of select="gsm-sima-timer"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(gsm-simb-timer)>0">
        <tr>
        <td align="left">Если ППКОП оснащен двумя SIM-картами и необходимо периодически проверять SIM-B, выполнять это
        не реже, чем через суток
        </td>
        <td align="right"><xsl:value-of select="gsm-sima-timer"/></td>
        </tr>
    </xsl:if>

    <!-- ... и для телефонного канала -->
    <xsl:if test="count(dial/dial-attempts)>0">
        <tr>
        <td align="left">Количество попыток дозвона подряд по одному номеру</td>
        <td align="right"><xsl:value-of select="dial/dial-attempts"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(dial/dial-rounds)>0">
        <tr>
        <td align="left">Количество проходов по всему списку номеров дозвона</td>
        <td align="right"><xsl:value-of select="dial/dial-rounds"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(dial/dial-delay)>0">
        <tr>
        <td align="left">Пауза между звонками при занятости телефона, сек.</td>
        <td align="right"><xsl:value-of select="dial/dial-delay"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(dial/reset_to_first_phone)>0">
        <tr>
        <td align="left">Дозвон в канале GSM всегда начинается с первого из телефонов списка</td>
        <td align="right">Да</td>
        </tr>
    </xsl:if>

    <xsl:if test="count(dial/dial-faults)>0">
        <tr>
        <td align="left">Направление доставки блокируется, если подряд не отправлено извещений</td>
        <td align="right"><xsl:value-of select="dial/dial-faults"/></td>
        </tr>
    </xsl:if>

    <td align="left">Способ набора номера телефона (канал ТфОП)</td>
    <xsl:if test="count(dial/pulse)>0">
        <td align="right">Импульсный</td>
    </xsl:if>
    <xsl:if test="count(dial/pulse)=0">
        <td align="right">Тональный</td>
    </xsl:if>

    <xsl:if test="count(min-active-settle-time)=0">
        <xsl:if test="count(phone-settle-time)>0">
            <tr>
            <td align="left">Если канал ТфОП работает, проверять восстановление направления доставки через сек.
            </td>
            <td align="right"><xsl:value-of select="phone-settle-time"/></td>
            </tr>
        </xsl:if>
    </xsl:if>

    <tr>
    <td align="left">Проверять состояние канала ТфОП (сигнал "Ответ станции"), даже если все шлейфы сняты с охраны</td>
    <xsl:if test="count(lazy-check)>0"><td align="right">Нет</td></xsl:if>
    <xsl:if test="count(lazy-check)=0"><td align="right">Да</td></xsl:if>
    </tr>

    <xsl:if test="count(phone-check-period)>0">
        <tr>
        <td align="left">Периодичность проверки наличия сигнала "Ответ станции" в канале ТфОП, мин.</td>
        <td align="right"><xsl:value-of select="phone-check-period"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(min-active-settle-time)>0">
        <tr>
        <td align="left">Минимальное время восстановления направления доставки, если у получателя есть извещения, мин.</td>
        <td align="right"><xsl:value-of select="format-number(min-active-settle-time div 60,'#####0')"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(min-settle-time)>0">
        <tr>
        <td align="left">Минимальное время восстановления направления доставки, если у получателя нет извещений, мин.</td>
        <td align="right"><xsl:value-of select="format-number(min-settle-time div 60,'#####0')"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(max-settle-time)>0">
        <tr>
        <td align="left">Максимальное время восстановления направления доставки, мин.</td>
        <td align="right"><xsl:value-of select="format-number(max-settle-time div 60,'#####0')"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(lars-check-period)>0">
        <tr>
        <td align="left">Периодичность проверки связи с передатчиком LARS, мин.</td>
        <td align="right"><xsl:value-of select="lars-check-period"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(lars-settle-time)>0">
        <tr>
        <td align="left">Если связь с передатчиком LARS потеряна, проверять восстановление связи через, сек.
        </td>
        <td align="right"><xsl:value-of select="lars-settle-time"/></td>
        </tr>
    </xsl:if>

    <tr>
        <td align="left">Длительность звукового сигнала, индицирующего отсутствие всех видов связи, мин.</td>
        <td align="right">
        <xsl:if test="count(sound/nocommunications-sound-time)>0">
            <xsl:if test="sound/nocommunications-sound-time='0'">Сигнал отключен</xsl:if>
            <xsl:if test="sound/nocommunications-sound-time&gt;'0'"><xsl:value-of select="sound/nocommunications-sound-time"/></xsl:if>
            
        </xsl:if>

        <xsl:if test="count(sound/nocommunications-sound-time)=0">Сигнал отключен</xsl:if>
        </td>
    </tr>

    <xsl:if test="count(max-tap-time)>0">
        <tr>
        <td align="left">Максимальное время занятия канала GSM (голосовая связь, прослушивание, удаленный доступ), мин.</td>
        <td align="right"><xsl:value-of select="max-tap-time"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(incoming-call-cfm-time)>0">
        <tr>
        <td align="left">Максимальное время для разрешения входящего голосового звонка, сек<br/>
        (Если не разрешить, через это время вызов будет отклонен)</td>
        <td align="right"><xsl:value-of select="incoming-call-cfm-time"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(max-ademco-per-seanse)>0">
        <tr>
        <td align="left">Максимальное число извещений, передаваемых в сеансе протоколами Ademco и Pro-T</td>
        <td align="right"><xsl:value-of select="max-ademco-per-seanse"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(max-csd-per-seanse)>0">
        <tr>
        <td align="left">Максимальное число извещений, передаваемых в сеансе протоколами Pro-M и Argus-CT</td>
        <td align="right"><xsl:value-of select="max-csd-per-seanse"/></td>
        </tr>
    </xsl:if>

    <!--

    <xsl:if test="count(max-gprs-per-seanse)>0">
        <tr>
        <td align="left">Максимальное число извещений, передаваемых в сеансе протоколом Pro-Net (GPRS)</td>
        <td align="right"><xsl:value-of select="max-gprs-per-seanse"/></td>
        </tr>
    </xsl:if>

    -->

    <xsl:if test="count(max-voice-per-seanse)>0">
        <tr>
        <td align="left">Максимальное число извещений, передаваемых в сеансе голосом</td>
        <td align="right"><xsl:value-of select="max-voice-per-seanse"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(voice-msg-repts)>0">
        <tr>
        <td align="left">Количество повторов голосового извещения</td>
        <td align="right"><xsl:value-of select="voice-msg-repts"/></td>
        </tr>
    </xsl:if>

    <xsl:for-each select="sntp-server">
        <xsl:sort select="@id" data-type="text"/>
        <tr>
            <td align="left">Сервер синхронизации времени <xsl:value-of select="@id"/></td>
            <td align="left">&#160;<xsl:value-of select="@ip"/></td>
        </tr>
    </xsl:for-each>

    <xsl:if test="count(timezone)>0">
        <tr>
        <td align="left">Часовой пояс - смещение времени относительно UTC (всемирного координированного времени), час</td>
        <td align="right"><xsl:value-of select="timezone"/></td>
        </tr>
    </xsl:if>

    <xsl:if test="count(loops)>0">
        <tr>
        <td align="left">Альтернативная индикация состояния шлейфов светодиодами</td>
        <td align="left">&#160;
        <xsl:if test="count(loops[@alternate-ind='Y'])>0">Включена</xsl:if>
        <xsl:if test="count(loops[@alternate-ind='Y'])=0">Выключена</xsl:if>
        </td>
        </tr>
    </xsl:if>

    <!-- Теперь шлейфы - только типы. В варианте с расширителем и без -->
    <xsl:for-each select="loops/group">
        <xsl:sort select="@id" data-type="text"/>
        <tr>
            <td align="center"><b>Подключены через расширитель 
            <xsl:if test="count(@onbus)=1">
                &#160;SE-10&#160;№ <xsl:value-of select="@id * 10"/>
            </xsl:if>
            <xsl:if test="count(@onbus)=0">
                &#160;SE-08&#160;№ <xsl:value-of select="@id"/>
            </xsl:if>
            </b>&#160;
            <font color="#0000ff"><xsl:value-of select="description"/></font>
            </td>
            <td align="left">&#160;</td>
        </tr>
        <xsl:for-each select="loop">
            <xsl:sort select="@id" data-type="text"/>
            <tr>
            <xsl:if test="count(@tampertype)=0">
              <td align="left">&#160;Шлейф <xsl:value-of select="@id"/><xsl:if test="$withpartition!=''"><xsl:if test="@partition!=''">, раздел <xsl:value-of select="@partition"/></xsl:if></xsl:if>
              &#160;
              <font color="#0000ff"><xsl:value-of select="description"/></font>
              </td>
              <td align="left">&#160;
              <!-- <xsl:value-of select="@type"/>&#160;- -->
                 <xsl:call-template name="get-loop-type">
                     <xsl:with-param name="type" select="@type"/>
                 </xsl:call-template>
              </td>
            </xsl:if>
            <xsl:if test="count(@tampertype)>0">
              <td align="left">&#160;Тампер <xsl:value-of select="@id"/>
              &#160;
              <font color="#0000ff"><xsl:value-of select="description"/></font>
              </td>
              <td align="left">&#160;
                 <xsl:call-template name="get-dpin-type">
                     <xsl:with-param name="type" select="@tampertype"/>
                 </xsl:call-template>
              </td>
            </xsl:if>
            </tr>
        </xsl:for-each>
    </xsl:for-each>

    <xsl:if test="count(loops/loop)>0">
        <xsl:if test="count(loops/group)>0">
            <tr>
                <td align="center"><b>Подключены к входам</b></td>
                <td align="left">&#160;</td>
            </tr>
        </xsl:if>
        <xsl:for-each select="loops/loop">
            <xsl:sort select="@id" data-type="text"/>
            <tr>
            <xsl:if test="count(@tampertype)=0">
                <td align="left">&#160;Шлейф <xsl:value-of select="@id"/><xsl:if test="$withpartition!=''"><xsl:if test="@partition!=''">, раздел <xsl:value-of select="@partition"/></xsl:if></xsl:if>
                &#160;
                <font color="#0000ff"><xsl:value-of select="description"/></font>
                </td>
                <td align="left">&#160;
                <!-- <xsl:value-of select="@type"/>&#160;- -->
                   <xsl:call-template name="get-loop-type">
                       <xsl:with-param name="type" select="@type"/>
                   </xsl:call-template>
                </td>
            </xsl:if>
            <xsl:if test="count(@tampertype)>0">
              <td align="left">&#160;Тампер <xsl:value-of select="@id"/>
              &#160;
              <font color="#0000ff"><xsl:value-of select="description"/></font>
              </td>
              <td align="left">&#160;
                 <xsl:call-template name="get-dpin-type">
                     <xsl:with-param name="type" select="@tampertype"/>
                 </xsl:call-template>
              </td>
            </xsl:if>
            </tr>
        </xsl:for-each>
    </xsl:if>

    <!-- Тамперная группа ("сухие" контакты) -->

    <xsl:if test="count(dpins/dpin)>0">
        <tr>
            <td align="center"><b>Тамперная группа</b></td>
            <td align="left">&#160;</td>
        </tr>
    <xsl:for-each select="dpins/dpin">
        <xsl:sort select="@id" data-type="number"/>
        <tr>
        <td align="left">&#160;Тампер <xsl:value-of select="@id"/>&#160;
        <font color="#0000ff"><xsl:value-of select="description"/></font>
        </td>
        <td align="left">&#160;
        <!-- <xsl:value-of select="@type"/>&#160;- -->
           <xsl:call-template name="get-dpin-type">
               <xsl:with-param name="type" select="@type"/>
           </xsl:call-template>
        </td>
        </tr>
    </xsl:for-each>
    </xsl:if>
</table>

<xsl:if test="count(keyboard)>0">
    <h3 align="center">Клавиатуры</h3>
    <table border="1" cellpadding="2" cellspacing="2" width="50%" align="center">
    <tr>
        <td align="center">Адрес</td>
        <td align="center">&#160;&#160;&#160;&#160;&#160;Тип&#160;&#160;&#160;&#160;&#160;</td>
        <td align="center">Разрешенные разделы</td>
        <td align="center">Режим работы<sup>1</sup></td>
        <td align="center">Показывать номер ППКОП</td>
        <td align="center">Сброс пожарных<sup>2</sup></td>
        <td align="center">Тревожная кнопка<sup>3</sup></td>
        <td align="center">Переход в неактивное через..., минут<sup>4</sup></td>
        <td align="center">Звуковая сигнализация</td>
    </tr>
     <xsl:for-each select="keyboard">
     <xsl:sort select="@addr" data-type="number"/>
        <xsl:variable name="keyboard-flags">0<xsl:value-of select="@kbdflags"/></xsl:variable>
        <xsl:variable name="addr">0<xsl:value-of select="@addr"/></xsl:variable>
        <tr>
            <td align="right"><xsl:value-of select="@addr"/>&#160;</td>
            <td align="left">&#160;<xsl:value-of select="@type"/></td>
            <td align="left">&#160;<xsl:value-of select="@partition"/></td>
            <td align="left">
                <xsl:if test="$addr &lt; 100">
                    <xsl:if test="(floor($keyboard-flags div 4) mod 2) = 1"><font color="#ff0000"><b>Обычный</b></font></xsl:if>
                    <xsl:if test="(floor($keyboard-flags div 4) mod 2) = 0">Безопасный</xsl:if>
                </xsl:if>
                <!-- xsl:if test="$addr &gt; 100">
                    По коду
                </xsl:if -->
            </td>
            <td align="left">
                <xsl:if test="$addr &lt; 100">
                    <xsl:if test="(floor($keyboard-flags div 32) mod 2) = 0">&#160;Да</xsl:if>
                    <xsl:if test="(floor($keyboard-flags div 32) mod 2) = 1"><font color="#ff0000">&#160;Нет</font></xsl:if>
                </xsl:if>
            </td>
            <td align="left">
                <xsl:if test="$addr &lt; 100">
                    <xsl:if test="(floor($keyboard-flags div 8) mod 2) = 1">&#160;Разрешен</xsl:if>
                    <xsl:if test="(floor($keyboard-flags div 8) mod 2) = 0"><font color="#ff0000">&#160;<b>Запрещен</b></font></xsl:if>
                </xsl:if>
            </td>
            <td align="left">
                <xsl:if test="$addr &lt; 100">
                    <xsl:if test="(floor($keyboard-flags div 16) mod 2) = 1">&#160;Разрешена</xsl:if>
                    <xsl:if test="(floor($keyboard-flags div 16) mod 2) = 0"><font color="#ff0000">&#160;Запрещена</font></xsl:if>
                </xsl:if>
            </td>
            <td align="right"><xsl:value-of select="@standbytime"/>&#160;</td>
            <td align="left">
                <xsl:if test="$addr &lt; 100">
                    <xsl:if test="(floor($keyboard-flags div 2) mod 2) = 1">&#160;Разрешена</xsl:if>
                    <xsl:if test="(floor($keyboard-flags div 2) mod 2) = 0"><font color="#ff0000">&#160;Запрещена</font></xsl:if>
                </xsl:if>
            </td>
        </tr>
     </xsl:for-each>
   </table>
   <br/>
    <p align="justify">
    <b>&#160;&#160;&#160;&#160;&#160;Примечания.</b><br/>
    &#160;&#160;&#160;&#160;&#160;1. <b>Обычный</b> - просмотр состояния разделов и зон любым лицом,&#160;&#160;<b>Безопасный</b> - просмотр состояния разделов и зон только после ввода правильного кода<br/>
    &#160;&#160;&#160;&#160;&#160;2. <b>Сброс пожарных с клавиатуры</b> - нажата # (<b>&#8594;</b>) более 3 сек.<br/>
    &#160;&#160;&#160;&#160;&#160;3. <b>Тревожная кнопка на клавиатуре</b> - одновременно нажаты *  (<b>&#8592;</b>) и # (<b>&#8594;</b>) более 3 сек.<br/>
    &#160;&#160;&#160;&#160;&#160;4. Клавиатура перейдет в неактивное состояние, если не нажата ни одна клавиша. Время 0 означает, что клавиатура всегда активна<br/>
    </p>
   <br/>
</xsl:if>


<xsl:if test="count(gprs)>0">

    <h3 align="center">Настройки TCP-обмена</h3>

   <table border="1" cellpadding="2" cellspacing="2" width="50%" align="center">
       <xsl:if test="count(gprs/tcp-period)>0">
          <tr>
            <td align="left">&#160;Время действия ключей (минимальный период связи) TCP, минут</td>
            <td align="right"><xsl:value-of select="gprs/tcp-period/@value"/>&#160;</td>
          </tr>
       </xsl:if>
       <xsl:if test="count(gprs/cfm-tiot)>0">
          <tr>
            <td align="left">&#160;Время ожидания подтверждения приема извещения, секунд</td>
            <td align="right"><xsl:value-of select="gprs/cfm-tiot/@value"/>&#160;</td>
          </tr>
       </xsl:if>
       <xsl:if test="count(gprs/tcp-hold-time)>0">
          <tr>
            <td align="left">&#160;Время удержания TCP-сессии, миллисекунд</td>
            <td align="right"><xsl:value-of select="gprs/tcp-hold-time/@value"/>&#160;</td>
          </tr>
       </xsl:if>
       <!-- xsl:if test="count(gprs/gprs-recovery)>0">
          <tr>
            <td align="left">&#160;Период восстановления связи с GPRS-сервером, секунд</td>
            <td align="right"><xsl:value-of select="gprs/gprs-recovery/@value"/>&#160;</td>
          </tr>
       </xsl:if -->
       <xsl:if test="count(gprs/udp-retryes)>0">
          <tr>
            <td align="left">&#160;Количество повторов передачи <b>извещений</b> по UDP</td>
            <td align="right"><xsl:value-of select="gprs/udp-retryes/@value"/>&#160;</td>
          </tr>
       </xsl:if>
       <xsl:if test="count(gprs/udp-period)>0 and gprs/udp-period/@value>0">
          <tr>
            <td align="left">&#160;Периодичность передачи UDP-тестов (&quot;прогрева&quot; канала связи), секунд</td>
            <td align="right"><xsl:value-of select="gprs/udp-period/@value"/>&#160;</td>
          </tr>
       </xsl:if>
   </table>

   <xsl:if test="count(ethernet)>0">
   <h3 align="center">Настройки Ethernet</h3>
      <table border="1" cellpadding="2" cellspacing="2" width="30%" align="center">
          <xsl:if test="count(ethernet/ip)=0">
             <tr>
               <td align="left">&#160;IP-адрес модуля, маска подсети, IP адрес шлюза</td>
               <td align="right">&#160;получаются через DHCP&#160;</td>
             </tr>
          </xsl:if>
          <xsl:if test="count(ethernet/ip)>0">
             <tr>
               <td align="left">&#160;IP адрес модуля</td>
               <td align="right"><xsl:value-of select="ethernet/ip"/>&#160;</td>
             </tr>
          </xsl:if>
          <xsl:if test="count(ethernet/mask)>0">
             <tr>
               <td align="left">&#160;Маска подсети</td>
               <td align="right"><xsl:value-of select="ethernet/mask"/>&#160;</td>
             </tr>
          </xsl:if>
          <xsl:if test="count(ethernet/gate)>0">
             <tr>
               <td align="left">&#160;IP адрес шлюза</td>
               <td align="right"><xsl:value-of select="ethernet/gate"/>&#160;</td>
             </tr>
          </xsl:if>
          <xsl:if test="count(ethernet/dns1)>0">
             <tr>
               <td align="left">&#160;Предпочитаемый DNS-сервер</td>
               <td align="right"><xsl:value-of select="ethernet/dns1"/>&#160;</td>
             </tr>
          </xsl:if>
          <xsl:if test="count(ethernet/dns2)>0">
             <tr>
               <td align="left">&#160;Альтернативный DNS-сервер</td>
               <td align="right"><xsl:value-of select="ethernet/dns2"/>&#160;</td>
             </tr>
          </xsl:if>
          <xsl:if test="count(ethernet/dns1)=0">
             <tr>
               <td align="left">&#160;Адрес DNS сервера</td>
               <td align="right">&#160;получается через DHCP&#160;</td>
             </tr>
          </xsl:if>
      </table>
   </xsl:if>

   <xsl:if test="count(gprs/apn)>0">
    <h3 align="center">Настройки GPRS</h3>
    <table border="1" cellpadding="2" cellspacing="2" width="50%" align="center">
     <tr>
      <td align="center">SIM</td> <td align="center">APN</td> <td align="center">USER</td>
      <td align="center">PASSWORD</td>
     </tr>
     <xsl:for-each select="gprs/apn">
     <xsl:sort select="@id" data-type="number"/>
      <tr>
       <td align="center">
         <b>
         <xsl:if test="@id='0' or @id='A' or @id='a'">A</xsl:if>
         <xsl:if test="@id='1' or @id='B' or @id='b'">B</xsl:if>
         <xsl:if test="@id='2'">A - резерв<br/>
         <xsl:if test="@apn-time='0'">(без возврата к основной APN)</xsl:if>
         <xsl:if test="@apn-time &gt; 0">(возврат к основной APN через <xsl:value-of select="@apn-time"/> мин.)</xsl:if>
         </xsl:if>
         </b>
       </td>
       <td align="center">
         <xsl:if test="@name!=''">&quot;<xsl:value-of select="@name"/>&quot;</xsl:if>
         <xsl:if test="count(@name)=0"><font color="#0000ff">ВНИМАНИЕ! APN не задан!</font></xsl:if>
       </td>
       <td align="center">
         <xsl:if test="@user!=''">&quot;<xsl:value-of select="@user"/>&quot;</xsl:if>
         <xsl:if test="count(@user)=0">не используется</xsl:if>
       </td>
       <td align="center">
       <xsl:if test="@pass!=''">&quot;<xsl:value-of select="@pass"/>&quot;</xsl:if>
       <xsl:if test="count(@pass)=0">не используется</xsl:if>
       </td>
     </tr>
     </xsl:for-each>
    </table>

    <xsl:if test="count(gprs/dns1)>0">
      <br/><br/>
      <table border="1" cellpadding="2" cellspacing="2" width="30%" align="center">
         <tr><td align="center">Предпочитаемый DNS-сервер</td><td align="center"><xsl:value-of select="gprs/dns1"/></td></tr>
         <xsl:if test="count(gprs/dns2)>0">
              <tr><td align="center">Альтернативный DNS-сервер</td><td align="center"><xsl:value-of select="gprs/dns2"/></td></tr>
         </xsl:if>
      </table>
    </xsl:if>

   </xsl:if>
</xsl:if>

<xsl:if test="count(ecfg-server/ip)>0">
    <h3 align="center">Сервер конфигуратора</h3>
    <table border="1" cellpadding="2" cellspacing="2" width="30%" align="center">
      <xsl:if test="count(ecfg-server/ip)>0">
         <tr>
          <td align="center">Адрес</td>
          <td align="center"><xsl:value-of select="ecfg-server/ip"/></td>
         </tr>
      </xsl:if>
      <xsl:if test="count(ecfg-server/port)>0">
         <tr>
          <td align="center">Порт</td>
          <td align="center"><xsl:value-of select="ecfg-server/port"/></td>
         </tr>
      </xsl:if>
      <xsl:if test="count(ecfg-server/@act1)>0">
         <tr>
          <td align="center">Телефон активации</td>
          <td align="center"><xsl:value-of select="ecfg-server/@act1"/></td>
         </tr>
      </xsl:if>
      <xsl:if test="count(ecfg-server/@act2)>0">
         <tr>
          <td align="center">Телефон активации</td>
          <td align="center"><xsl:value-of select="ecfg-server/@act2"/></td>
         </tr>
      </xsl:if>
      <!-- xsl:if test="count(ecfg-server/polltime)>0">
          Период опроса сервера конфигуратора, мин.&#160;
          <xsl:value-of select="ecfg-server/polltime"/>
      </xsl:if>
      <xsl:if test="count(ecfg-server/polltime)=0">
          Cервер конфигуратора опрашивается при загрузке ППКОП.
      </xsl:if -->
    </table>
</xsl:if>

<xsl:if test="$displaylevel>3">
  <xsl:if test="count(ussd-req)>0">
    <h3 align="center">Контроль остатка средств</h3>
    <table border="1" cellpadding="2" cellspacing="2" align="center">
        <tr>
          <td align="center"><b>Параметр</b></td>
          <td align="center"><b>SIM-A</b></td>
          <td align="center"><b>SIM-B</b></td>
        </tr>
        <tr>
          <td align="left">&#160;USSD-запрос</td>
          <td align="right"><xsl:value-of select="//ussd-req/req[@id='0']/@str"/>&#160;</td>
          <td align="right"><xsl:value-of select="//ussd-req/req[@id='1']/@str"/>&#160;</td>
        </tr>
        <tr>
          <td align="left">&#160;Минимальный остаток</td>
          <td align="right"><xsl:value-of select="//ussd-req/req[@id='0']/@minmoney"/>&#160;</td>
          <td align="right"><xsl:value-of select="//ussd-req/req[@id='1']/@minmoney"/>&#160;</td>
        </tr>
        <tr>
          <td align="left">&#160;Группа цифр с остатком средств</td>
          <td align="right"><xsl:value-of select="//ussd-req/req[@id='0']/@group"/>&#160;</td>
          <td align="right"><xsl:value-of select="//ussd-req/req[@id='1']/@group"/>&#160;</td>
        </tr>
        <tr>
          <td align="left">&#160;Периодичность запроса (часы:минуты)</td>
          <td colspan="2" align="center"><xsl:value-of select="//ussd-req/@period"/></td>
        </tr>
        <tr>
          <td align="left">&#160;Звуковой сигнал, если остаток<br/>&#160;средств ниже минимального</td>
          <xsl:if test="count(ussd-req/@sound)>0">
            <td colspan="2" align="center">Да</td>
          </xsl:if>
          <xsl:if test="count(ussd-req/@sound)=0">
            <td colspan="2" align="center">Нет</td>
          </xsl:if>
        </tr>
    </table>
  </xsl:if>
</xsl:if>


<h3 align="center">Шлейфы и тамперы. Детальные сведения</h3>

<xsl:if test="count(loops/group|loops/loop)>0">
    <xsl:for-each select="loops/group">
        <xsl:sort select="@id" data-type="text"/>
            <h4 align="left"><u>Подключены через расширитель 
            <xsl:if test="count(@onbus)=1">
                &#160;SE-10&#160;&#160;&#160;№ <xsl:value-of select="@id * 10"/>
            </xsl:if>
            <xsl:if test="count(@onbus)=0">
                &#160;SE-08&#160;&#160;&#160;№ <xsl:value-of select="@id"/>
            </xsl:if>
            </u>&#160;
                <xsl:if test="count(description)>0"><xsl:value-of select="description"/></xsl:if>
            </h4>
            <xsl:for-each select="loop">
                <xsl:sort select="@id" data-type="text"/>
                <xsl:call-template name="loop-fulldesc"/>
            </xsl:for-each>
    </xsl:for-each>

    <xsl:if test="count(loops/loop)>0">
        <xsl:if test="count(loops/group)>0">
            <h4 align="left"><u>Подключены к входам</u></h4>
        </xsl:if>

        <xsl:for-each select="loops/loop">
            <xsl:sort select="@id" data-type="text"/>
                <xsl:call-template name="loop-fulldesc"/>
        </xsl:for-each>
    </xsl:if>

    <p align="justify">
    <b>&#160;&#160;&#160;&#160;Примечание.</b>
    &#160;&#160;Перечислены параметры шлейфов, <b>отличные</b> от типовых, приведенных в общих настройках.
    </p>
</xsl:if>

<xsl:if test="count(dpins/dpin)>0">
<br/>
    <xsl:for-each select="dpins/dpin">
        <xsl:sort select="@id" data-type="number"/>
            <xsl:call-template name="dpin-fulldesc"/>
    </xsl:for-each>
</xsl:if>

<hr/>

<xsl:if test="count(keys/key)>0">
<h3 align="center">Ключи доступа Touch Memory и коды клавиатуры</h3>
<xsl:if test="keys[@singletouch='1']">
    <h4 align="center">(взятие под охрану и снятие с охраны выполняется однократным касанием считывателя ключом TM)</h4>
</xsl:if>

<table border="1" cellpadding="2" cellspacing="2" width="60%" align="center">
   <tr>
      <td align="center">Название и<br/>номер хозоргана</td>
      <xsl:if test="not($hidetmkeys=1)">
        <td align="center">&#160;Код или ключ<br/>(младшие 8 знаков)</td>
      </xsl:if>
      <td align="center">Права</td>
      <td align="center">Связанные разделы,<br/>объекты</td>
   </tr>
   <xsl:for-each select="keys/key">
   <xsl:sort select="@id" data-type="number"/>
   <tr>
   <td align="right"><xsl:value-of select="@name"/>&#160;&#160;&#160;<b><xsl:value-of select="@id"/>&#160;</b></td>
   <xsl:if test="not($hidetmkeys=1)">
       <td align="right">
       <xsl:value-of select="@code"/>&#160;
       </td>
   </xsl:if>
   <td align="left">&#160;
       <xsl:if test="@keytype='3'"><font color="#ff0000"><b><xsl:value-of select="@rights"/></b></font></xsl:if>
       <xsl:if test="not(@keytype='3')">
            <xsl:if test="not(@id='master')">
                <xsl:if test="@keytype='0'"><xsl:if test="count(@partition)=0">Отметка наряда</xsl:if></xsl:if>
                <xsl:if test="@keytype>'0' or count(@partition)>0"><xsl:value-of select="@rights"/></xsl:if>
            </xsl:if>
       </xsl:if>
   </td>
   <!-- связанные разделы -->
   <td align="left">&#160;
    <xsl:if test="count(@partition)>0">Разделы <xsl:value-of select="@partition"/></xsl:if>
    <xsl:if test="count(@relay)>0">Реле <xsl:value-of select="@relay"/></xsl:if>
    <xsl:if test="count(@openc)>0">Выход ОК <xsl:value-of select="@openc"/></xsl:if>
   </td>
   </tr>
   </xsl:for-each>
</table>
</xsl:if>

<xsl:if test="count(sound)>0">
<h3 align="center">Звуковой сигнализатор</h3>
<table border="1" cellpadding="2" cellspacing="2" width="60%" align="center">
    <xsl:if test="$displaylevel>1">
        <xsl:if test="count(sound/job-alarm)>0">
        <tr>
        <td align="left">Программа тревоги</td>
        <xsl:variable name="pt"><xsl:value-of select="sound/job-alarm"/>Стандартная</xsl:variable>
        <xsl:variable name="pt1">
            <xsl:if test="$pt='Стандартная'">T400F2400+F1600+ (по умолчанию)</xsl:if>
            <xsl:if test="not($pt='Стандартная')"><xsl:value-of select="sound/job-alarm"/></xsl:if>
        </xsl:variable>
        <td align="left">&#160;
        <xsl:if test="sound/job-alarm/@permanent='Y'"><font color="#ff0000"><xsl:value-of select="$pt1"/></font></xsl:if>
        <xsl:if test="not(sound/job-alarm/@permanent='Y')"><xsl:value-of select="$pt1"/></xsl:if>
        </td>
        </tr>
        </xsl:if>
        <tr>
        <td align="left">Программа пожара</td>
            <xsl:if test="count(sound/fire-alarm)>0">
            <td align="left">&#160;<xsl:value-of select="sound/fire-alarm"/></td>
            </xsl:if>
            <xsl:if test="count(sound/fire-alarm)=0">
            <td align="left">&#160;R4000F800+-F800+-T100F2400+F1600+- (по умолчанию)</td>
            </xsl:if>
        </tr>
        <tr>
        <td align="left">Программа входящего звонка</td>
        <xsl:variable name="pt"><xsl:value-of select="sound/call-alarm"/>Стандартная</xsl:variable>
        <xsl:variable name="pt1">
            <xsl:if test="$pt='Стандартная'">T500-+-+-+-+- (по умолчанию)</xsl:if>
            <xsl:if test="not($pt='Стандартная')"><xsl:value-of select="sound/call-alarm"/></xsl:if>
        </xsl:variable>
        <td align="left">&#160;
            <xsl:value-of select="$pt1"/>
        </td>
        </tr>
    </xsl:if>
    <xsl:if test="count(sound/loop|sound/group)>0">
        <tr>
          <xsl:if test="$withpartition!=''">
            <td align="left">Связанные разделы</td>
            <td align="left">
                 &#160;
                    <xsl:value-of select="sound/@partition"/>
            </td>
          </xsl:if>
        </tr>
    </xsl:if>
</table>
</xsl:if>

<xsl:if test="count(relays/relay)>0">
<h3 align="center">Реле</h3>
<table border="1" cellpadding="2" cellspacing="2" width="95%" align="center">
   <tr>
      <td align="center">№</td>
      <td align="center">Тип</td>
      <xsl:if test="not($withpartition!='')"><td align="center">Связанные шлейфы</td></xsl:if>
      <xsl:if test="$withpartition!=''"><td align="center">Связанные разделы</td></xsl:if>
    <xsl:if test="$displaylevel>1">
      <td align="center">Программа вкл., постановки, замка, входящего звонка</td>
      <td align="center">Программа выкл., снятия</td>
      <td align="center">Программа тревоги</td>
    </xsl:if>
   </tr>
   <xsl:for-each select="relays/relay">
   <xsl:sort select="@id" data-type="number"/>
    <tr>
    <td align="right"><xsl:value-of select="@id"/>&#160;</td>
    <td align="left">
      &#160;<xsl:value-of select="@type"/>&#160;-
      <xsl:call-template name="get-relay-type">
          <xsl:with-param name="type" select="@type"/>
      </xsl:call-template>
      <xsl:if test="count(description)>0">
          <br/>&#160;<xsl:value-of select="description"/>
      </xsl:if>
      <xsl:if test="count(@alarmonly)>0">
          <br/>&#160;Срабатывает и при тревогах, и при неисправностях (КЗ или обрыв пожарного шлейфа и т.п.)
      </xsl:if>
    </td>

     <!-- Если реле относится к термодатчику, нужно вписать это и не выводить программы -->
    <xsl:if test="$termohigh=@id or $termolow=@id">
        <td align="left">&#160;Термодатчик</td>
        <td>&#160;</td><td>&#160;</td><td>&#160;</td>
    </xsl:if>
    <xsl:if test="$termohigh!=@id and $termolow!=@id">
        <!-- собираем связанные разделы -->
        <td align="left">
            &#160;
            <xsl:if test="$withpartition!=''">
                <xsl:value-of select="@partition"/>
            </xsl:if>
        </td>

        <xsl:if test="$displaylevel>1">
           <td>&#160;
            <xsl:if test="count(job-on)>0">
                <xsl:if test="job-on/@permanent='Y'"><font color="#ff0000"><xsl:value-of select="job-on"/></font></xsl:if>
                <xsl:if test="not(job-on/@permanent='Y')"><xsl:value-of select="job-on"/></xsl:if>
            </xsl:if>
           </td>
           <td>&#160;
            <xsl:if test="count(job-off)>0">
                <xsl:if test="job-off/@permanent='Y'"><font color="#ff0000"><xsl:value-of select="job-off"/></font></xsl:if>
                <xsl:if test="not(job-off/@permanent='Y')"><xsl:value-of select="job-off"/></xsl:if>
            </xsl:if>
           </td>
           <td>&#160;
            <xsl:if test="count(job-alarm)>0">
                <xsl:if test="job-alarm/@permanent='Y'"><font color="#ff0000"><xsl:value-of select="job-alarm"/></font></xsl:if>
                <xsl:if test="not(job-alarm/@permanent='Y')"><xsl:value-of select="job-alarm"/></xsl:if>
            </xsl:if>
           </td>
        </xsl:if>
    </xsl:if>
   </tr>
  </xsl:for-each>
</table>
</xsl:if>

<xsl:if test="count(openc/relay)>0">
<h3 align="center">Выходы ОК</h3>
<table border="1" cellpadding="2" cellspacing="2" width="95%" align="center">
   <tr>
      <td align="center">№</td>
      <td align="center">Тип</td>
      <xsl:if test="not($withpartition!='')"><td align="center">Связанные шлейфы</td></xsl:if>
      <xsl:if test="$withpartition!=''"><td align="center">Связанные разделы</td></xsl:if>
    <xsl:if test="$displaylevel>1">
      <td align="center">Программа вкл., постановки, замка, входящего звонка</td>
      <td align="center">Программа выкл., снятия</td>
      <td align="center">Программа тревоги</td>
    </xsl:if>
   </tr>
   <xsl:for-each select="openc/relay">
   <xsl:sort select="@id" data-type="number"/>
    <tr>
    <td align="right"><xsl:value-of select="@id"/>&#160;</td>
    <td align="left">
      &#160;<xsl:value-of select="@type"/>&#160;-
      <xsl:call-template name="get-relay-type">
          <xsl:with-param name="type" select="@type"/>
      </xsl:call-template>
      <xsl:if test="count(description)>0">
          <br/>&#160;<xsl:value-of select="description"/>
      </xsl:if>
      <xsl:if test="count(@alarmonly)>0">
          <br/>&#160;Срабатывает и при тревогах, и при неисправностях (КЗ или обрыв пожарного шлейфа и т.п.)
      </xsl:if>
    </td>

     <!-- Если ОК относится к термодатчику, нужно вписать это и не выводить программы -->
    <xsl:if test="$termohigh1=@id or $termolow1=@id">
        <td align="left">&#160;Термодатчик</td>
        <td>&#160;</td><td>&#160;</td><td>&#160;</td>
    </xsl:if>
    <xsl:if test="$termohigh1!=@id and $termolow1!=@id">
        <!-- И собираем связанные разделы -->
        <td align="left">
            &#160;
            <xsl:if test="$withpartition!=''">
                <xsl:value-of select="@partition"/>
            </xsl:if>
        </td>

        <xsl:if test="$displaylevel>1">
           <td>&#160;
            <xsl:if test="count(job-on)>0">
                <xsl:if test="job-on/@permanent='Y'"><font color="#ff0000"><xsl:value-of select="job-on"/></font></xsl:if>
                <xsl:if test="not(job-on/@permanent='Y')"><xsl:value-of select="job-on"/></xsl:if>
            </xsl:if>
           </td>
           <td>&#160;
            <xsl:if test="count(job-off)>0">
                <xsl:if test="job-off/@permanent='Y'"><font color="#ff0000"><xsl:value-of select="job-off"/></font></xsl:if>
                <xsl:if test="not(job-off/@permanent='Y')"><xsl:value-of select="job-off"/></xsl:if>
            </xsl:if>
           </td>
           <td>&#160;
            <xsl:if test="count(job-alarm)>0">
                <xsl:if test="job-alarm/@permanent='Y'"><font color="#ff0000"><xsl:value-of select="job-alarm"/></font></xsl:if>
                <xsl:if test="not(job-alarm/@permanent='Y')"><xsl:value-of select="job-alarm"/></xsl:if>
            </xsl:if>
           </td>
        </xsl:if>
    </xsl:if>
   </tr>
  </xsl:for-each>
</table>
</xsl:if>

<p align="justify">
<b>&#160;&#160;&#160;&#160;&#160;Примечания.</b><br/>
&#160;&#160;&#160;&#160;&#160;1. Для реле, выходов и звукового сигнализатора цветом выделены
<font color="#ff0000">постоянные программы</font>,
<!-- (атрибут программы permanent="Y")-->
которые по завершению безусловно повторяются, пока не изменятся условия
их активировавшие.<br/>
&#160;&#160;&#160;&#160;&#160;2. Не используемые для управления внешними устройствами выходы 1...6
копируют состояние соответствующих индикаторов И1...И6.
</p>

<xsl:if test="count(ds1820)>0">
<h3 align="center">Датчик температуры</h3>
    <table border="1" cellpadding="2" cellspacing="2" align="center">
        <xsl:if test="count(ds1820/@lowalarm)>0">
            <tr><td>&#160;Передать извещение, если температура датчика ниже, °C&#160;</td><td>&#160;<xsl:value-of select="ds1820/@lowalarm"/>&#160;</td></tr>
        </xsl:if>    
        <xsl:if test="count(ds1820/@highalarm)>0">
            <tr><td>&#160;Передать извещение, если температура датчика выше, °C&#160;</td><td>&#160;<xsl:value-of select="ds1820/@highalarm"/>&#160;</td></tr>
        </xsl:if>    
        <xsl:if test="count(ds1820/@lowtext)>0">
            <tr><td>&#160;<xsl:value-of select="ds1820/@lowtext"/>&#160;</td><td>&#160;</td></tr>
        </xsl:if>    
        <xsl:if test="count(ds1820/@hightext)>0">
            <tr><td>&#160;<xsl:value-of select="ds1820/@hightext"/>&#160;</td><td>&#160;</td></tr>
        </xsl:if>    
        <xsl:if test="count(ds1820/relay-hyst/@value)>0">
            <tr><td>&#160;Гистерезис возврата реле в исходное состояние, °C&#160;</td><td>&#160;<xsl:value-of select="ds1820/relay-hyst/@value"/>&#160;</td></tr>
        </xsl:if>    
    </table>

    <xsl:if test="count(ds1820/@lowalarm)>0">
        <xsl:if test="count(ds1820/own-msg)>0">
            <br/>&#160;&#160;<b>Индивидуальные SMS-сообщения:</b><br/>
            <xsl:for-each select="ds1820/own-msg">
                <xsl:sort select="@id" data-type="number"/>
                &#160;&#160;&#160;&#160;<xsl:value-of select="@id"/>. <xsl:value-of select="."/>
                <br/>
            </xsl:for-each>
        </xsl:if>

        <xsl:if test="count(ds1820/@phone)>0">
            &#160;&#160;&#160;&#160;&#160;Безусловно передать <b><xsl:value-of select="ds1820/@phone"/></b> СМС с температурой датчика в
            <b>
            <xsl:if test="count(ds1820/@t1)>0">&#160;&#160;<xsl:value-of select="ds1820/@t1"/></xsl:if>
            <xsl:if test="count(ds1820/@t1)>0">&#160;&#160;<xsl:value-of select="ds1820/@t2"/></xsl:if>
            <xsl:if test="count(ds1820/@t1)>0">&#160;&#160;<xsl:value-of select="ds1820/@t3"/></xsl:if>
            </b>
            <br/>
        </xsl:if>

        <p align="justify">
        <b>&#160;&#160;&#160;&#160;&#160;Примечания.</b><br/>
        &#160;&#160;&#160;&#160;&#160;1. Извещение отмены понижения или повышения температуры до критической передается, когда температура
        возвращается по крайней мере к порогу управления соответствующим реле.<br/>
        &#160;&#160;&#160;&#160;&#160;2. Реле переводится в исходное состояние, когда температура превышает нижний порог (или опускается ниже верхнего порога)
        на установленное в гистерезисе значение.
        </p>
    </xsl:if>    
</xsl:if>
        

<xsl:if test="count(ctlphones/phone)>0">
<h3 align="center">Телефоны управления</h3>
<table border="1" cellpadding="2" cellspacing="2" width="20%" align="center">
   <xsl:for-each select="ctlphones/phone">
    <xsl:sort select="@id" data-type="text"/>
    <tr><td align="left">&#160;<xsl:value-of select="."/></td></tr>
   </xsl:for-each>
</table>
<xsl:if test="count(ctlphones/@unk-sms-redirect)>0">
    <br/>
    <p align="center">SMS от оператора сотовой связи (короткие и текстовые номера)<br/>отправляются на первый из телефонов управления.</p>
    <br/>
</xsl:if>
</xsl:if>

<xsl:if test="count(tap-phones/phone)>0">
<h3 align="center">Телефоны прослушивания</h3>
<table border="1" cellpadding="2" cellspacing="2" width="20%" align="center">
   <xsl:for-each select="tap-phones/phone">
    <xsl:sort select="@id" data-type="text"/>
    <tr>
        <td align="left">
        &#160;<xsl:value-of select="."/>
        <xsl:if test="count(@loud)>0">&#160;(уведомление о звонке)</xsl:if>
        </td>
    </tr>
   </xsl:for-each>
</table>
</xsl:if>

<xsl:if test="count(recpt)>0">
<h3 align="center">Получатели</h3>
    <xsl:for-each select="recpt">
    <xsl:sort select="@id" data-type="number"/>
    <h4>
        Получатель&#160;<xsl:value-of select="@id"/>.&#160;&#160;
        <font color="#0000ff"><xsl:value-of select="description"/></font>
        &#160;&#160;
            <xsl:if test="count(@delivery)=0">Обязательная доставка, без шифрования</xsl:if>
            <xsl:if test="count(@delivery)>0">
                <xsl:variable name="dlvry"><xsl:value-of select="@delivery"/></xsl:variable>
                <xsl:if test="($dlvry mod 2) = 1">Обязательная доставка</xsl:if>
                <xsl:if test="($dlvry mod 2) = 0"><font color="#ff0000">Необязательная доставка</font></xsl:if>
                <xsl:if test="(floor($dlvry div 8) mod 2) = 1">, шифрование обязательно</xsl:if>
                <xsl:if test="(floor($dlvry div 8) mod 2) = 0">
                    <xsl:if test="(floor($dlvry div 4) mod 2) = 1">, шифрование используется, если оно поддерживается принимающей стороной</xsl:if>
                    <xsl:if test="(floor($dlvry div 4) mod 2) = 0">, без шифрования</xsl:if>
                </xsl:if>
            </xsl:if>
    </h4>
        <xsl:if test="count(@multipanel)>0 and $multipanelmode>1">
        <font color="#ff0000"><b>
            Внимание! Передавамый номер устройства зависит от номера раздела шлейфа.
            Для первого раздела он совпадает с основным, для второго - на 1 больше и т.д.
            (кроме SMS-извещений!)
            </b>
        </font>
        <br/>
        </xsl:if>
        Извещения:&#160;
        <xsl:if test="count(group)>0"><xsl:call-template name="collect-msg"/></xsl:if>
        <xsl:if test="count(group)=0"><font color="#ff0000"><b>отсутствуют</b></font> (возможна передача тестовых извещений).</xsl:if>
        &#160;&#160;&#160;&#160;&#160;&#160;
        <xsl:if test="$withpartition!='' and @partition!=''">
            Разделы:&#160;<xsl:value-of select="@partition"/><br/>
        </xsl:if>

        <xsl:for-each select="log-channel">
        <xsl:sort select="@id" data-type="number"/>
            <br/>
            <b>Направление доставки&#160;<xsl:value-of select="@id"/></b>.&#160;
            Протокол связи: &#160;
                   <xsl:call-template name="get-proto-type">
                       <xsl:with-param name="type" select="@proto"/>
                   </xsl:call-template>
            <xsl:if test="@smscode!=''">
                   &#160;
                   <xsl:call-template name="get-sms-code">
                       <xsl:with-param name="type" select="@smscode"/>
                   </xsl:call-template>
            </xsl:if>
            <xsl:if test="@altchan!=''">&#160;&#160;Резервное направление:&#160;<b><xsl:value-of select="@altchan"/></b>
            <xsl:variable name="altid"><xsl:value-of select="@altchan"/></xsl:variable>
            <xsl:if test="count(//log-channel[@id=$altid])=0">
                <b><font color="#ff0000">&#160;-&#160;отсутствует в конфигурации!!!</font></b>
            </xsl:if>
            </xsl:if>
            <br/>

            <xsl:for-each select="server">
              <xsl:if test="@id='0'"><font color="#ff0000">Основной сервер:&#160;</font></xsl:if>
              <xsl:if test="@id!='0'">Резервный сервер:</xsl:if>&#160;
              IP:&#160;<b>
              <xsl:if test="@ip!=''"><xsl:value-of select="@ip"/></xsl:if>
              <xsl:if test="count(@ip)=0">
                <xsl:if test="@id='0'">запрашивается</xsl:if>
                <xsl:if test="@id='1'">отсутствует</xsl:if>
              </xsl:if>&#160;&#160;
              </b>
              <xsl:if test="count(@tport)>0">
                <xsl:if test="@tport!=''">TCP порт: <b><xsl:value-of select="@tport"/></b>&#160;&#160;</xsl:if>
              </xsl:if>
              <xsl:if test="count(@uport)>0">
                <xsl:if test="@uport!='' and @uport!='0'">UDP порт: <b><xsl:value-of select="@uport"/></b></xsl:if>
              </xsl:if>
              <br/>
            </xsl:for-each>

            <xsl:if test="count(gprs/server)>0">
             <br/>
            </xsl:if>

            <xsl:if test="count(phone)+count(phonea)+count(phoneb)>0">
                <!-- Телефоны без СИМ-карты, СИМ-А и СИМ-Б -->
                Телефоны в порядке предпочтения:<br/>
                <xsl:if test="count(phone)>0">
                   <b>
                   <xsl:for-each select="phone">
                       &#160;<xsl:value-of select="."/><xsl:if test="position() &lt; last()">,</xsl:if>
                   </xsl:for-each>
                   </b>
                <br/>
                </xsl:if>

                <xsl:if test="count(phonea)>0">
                SIM-A:&#160;
                   <b>
                   <xsl:for-each select="phonea">
                       &#160;<xsl:value-of select="."/><xsl:if test="position() &lt; last()">,</xsl:if>
                   </xsl:for-each>
                   </b>
                <br/>
                </xsl:if>

                <xsl:if test="count(phoneb)>0">
                SIM-B:&#160;
                   <b>
                   <xsl:for-each select="phoneb">
                       &#160;<xsl:value-of select="."/><xsl:if test="position() &lt; last()">,</xsl:if>
                   </xsl:for-each>
                   </b>
                <br/>
                </xsl:if>
                <xsl:if test="count(phoneb)=0">
                    <xsl:if test="count(phonea)>0">
                        <b>Если SIM-B присутствует, используются те же телефоны, что и для SIM-A.</b><br/>
                    </xsl:if>
                </xsl:if>
            </xsl:if>

            <xsl:if test="count(test-period)>0">
              Период передачи тестовых извещений (<xsl:if test="contains(test-period,':')">часы, </xsl:if>минуты):&#160;<xsl:value-of select="test-period"/>
            </xsl:if>
            <xsl:if test="count(test-period)=0">
                Тестовые извещения не передаются.
            </xsl:if>
            <br/>
        </xsl:for-each>
        <br/><br/>
    </xsl:for-each>
</xsl:if>

<xsl:if test="count(phys-channel)>0">
<h3 align="center">Каналы передачи</h3>
<xsl:for-each select="phys-channel">
    <b><font color="#0000ff">
    Канал передачи: &#160;<!-- xsl:value-of select="@id"/> &#160;&#160;тип -->
    <xsl:if test="@type='gsm' or @type='gsm1'"> GSM основной.</xsl:if>
    <xsl:if test="@type='gsm2'"> GSM резервный.</xsl:if>
    <xsl:if test="@type='phone'"> ТфОП.</xsl:if>
    <xsl:if test="@pin!=''">
        PIN: <xsl:value-of select="@pin"/>
    </xsl:if>
    <br/>
    </font></b>
    <xsl:if test="@type='gsm2'">
        <xsl:if test="count(//gsm-switch)>0">
        Переход на GSM резервный выполняется <xsl:call-template name="get-gsm-switch"><xsl:with-param name="type" select="$gsmswitch"/></xsl:call-template>
         <xsl:if test="$gsmswitch &lt; 4">
            (менее <xsl:value-of select="//gsm-min-level"/> дБ)
         </xsl:if>
.
        <br/>
        </xsl:if>
    </xsl:if>
    <br/>
    <xsl:for-each select="log-channel">
    <b>Направление доставки&#160;<xsl:value-of select="@id"/></b>.&#160;&#160;
    <xsl:if test="count(description)>0">
        <font color="#0000ff"><xsl:value-of select="description"/></font>&#160;&#160;
    </xsl:if>
    Протокол связи: &#160;
           <xsl:call-template name="get-proto-type">
               <xsl:with-param name="type" select="@proto"/>
           </xsl:call-template>
    <xsl:if test="@altchan!=''">&#160;&#160;Альтернативное направление: &#160;<xsl:value-of select="@altchan"/>
    <xsl:variable name="altid"><xsl:value-of select="@altchan"/></xsl:variable>
    <xsl:if test="count(//log-channel[@id=$altid])=0">
        <b><font color="#ff0000">&#160;-&#160;отсутствует в конфигурации!!!</font></b>
    </xsl:if>
    </xsl:if>
    <br/>
    Телефоны в порядке предпочтения:
    <xsl:for-each select="phone">
        &#160;<xsl:value-of select="."/><xsl:if test="position() &lt; last()">,</xsl:if>
    </xsl:for-each>
    <br/>
    Извещения:&#160;
    <xsl:if test="count(group)>0"><xsl:call-template name="collect-msg"/></xsl:if>
    <xsl:if test="count(group)=0"><font color="#ff0000"><b>отсутствуют</b></font> (возможна передача тестовых извещений).</xsl:if>
    <br/>
    <xsl:if test="$withpartition!='' and @partition!=''">
        Разделы:&#160;<xsl:value-of select="@partition"/><br/>
    </xsl:if>
    <br/>
    <xsl:if test="count(test-period)>0">
      Период передачи тестовых извещений (<xsl:if test="contains(test-period,':')">часы, </xsl:if>минуты):&#160;<xsl:value-of select="test-period"/>
    </xsl:if>
    <xsl:if test="count(test-period)=0">
        Тестовые извещения не передаются.
    </xsl:if>
    <br/><br/>
    </xsl:for-each>
</xsl:for-each>
</xsl:if>

<xsl:if test="count(//log-channel)>0">
<p align="justify">
<b>&#160;&#160;&#160;&#160;&#160;Примечания.</b><br/>
&#160;&#160;&#160;&#160;&#160;1. Направление доставки использует один и более телефонов или IP-адресов,
указанных в порядке предпочтения. Извещение может быть передано по любому из этих телефонов (IP-адресов).
Если невозможно передать извещение, предпринимается попытка дозвона (установления соединения, отправки SMS)
по следующему номеру (адресу) и т.д. Если не удается отправить извещение
ни по одному из указанных телефонов (IP-адресов), используется резервное направление доставки, если такое указано.<br/>
&#160;&#160;&#160;&#160;&#160;После восстановления работоспособности направления доставки, оно вновь будет использоваться для передачи извещений.<br/>
&#160;&#160;&#160;&#160;&#160;2. Если разрешена передача тестовых извещений,
тестовое извещение будет отправлено не позже,
чем через указанный интервал времени после последней успешной отправки <b>любого</b> извещения.
Только если устройство не передает никаких других извещений (состояние датчиков не изменяется),
тестовые извещения будут передаваться с указанной периодичностью.<br/>
<xsl:if test="count(//recpt[@delivery='0'])>0">
&#160;&#160;&#160;&#160;&#160;
<font color="#ff0000">
3. Необязательная доставка означает, что извещение может быть удалено из
очереди передачи, если исчерпаны все попытки передачи.
</font>
</xsl:if>
</p>
<br/>
</xsl:if>

<xsl:if test="$displaylevel>3">
  <xsl:if test="count(sregs)>0">
    <h3 align="center">S-регистры</h3>
    <table border="1" cellpadding="2" cellspacing="2" align="center">
        <tr>
          <td align="center"><b>№№</b></td><td align="center"><b>Описание</b></td>
          <td align="center"><b>ТфОП</b></td><td align="center"><b>GSM</b></td>
        </tr>
    <xsl:for-each select="sregs[@type='phone']/sreg">
        <xsl:sort select="@id" data-type="number"/>
        <tr>
        <td align="right"><xsl:value-of select="@id"/>&#160;</td>
        <td align="left">&#160;
          <xsl:call-template name="get-sreg-desc">
              <xsl:with-param name="type" select="@id"/>
          </xsl:call-template>
        </td>
        <xsl:variable name="gsel"><xsl:value-of select="@id"/></xsl:variable>
        <td align="right"><xsl:value-of select="@value"/>&#160;</td>
        <td align="right"><xsl:value-of select="//sregs[@type='gsm']/sreg[@id=$gsel]/@value"/>&#160;</td>
        </tr>
    </xsl:for-each>
    </table>
  </xsl:if>
</xsl:if>

<xsl:if test="$displaylevel>3">
  <xsl:if test="count(msg-template)>0">
  <h3 align="center">Именованные наборы групп извещений (шаблоны)</h3>
  <table border="1" cellpadding="2" cellspacing="2" align="center">
  <tr><td align="center"><b>Название</b></td><td align="center"><b>Описание</b></td><td align="center"><b>Маски или номера групп</b></td></tr>
     <xsl:for-each select="msg-template">
      <tr>
      <td>&#160;<xsl:value-of select="@id"/>&#160;</td>
      <td>&#160;<xsl:value-of select="description"/>&#160;</td>
      <td>&#160;
          <xsl:for-each select="group">
              <xsl:value-of select="."/><xsl:if test="position() &lt; last()"> + </xsl:if>
          </xsl:for-each>
          &#160;
          <xsl:for-each select="nogroup">
              <xsl:if test="position()=1"> Кроме </xsl:if>
              <xsl:value-of select="."/><xsl:if test="position() &lt; last()"> + </xsl:if>
          </xsl:for-each>
          &#160;
      </td>
      </tr>
     </xsl:for-each>
  </table>
  </xsl:if>
</xsl:if>

<xsl:if test="$displaylevel>3">

  <xsl:if test="count(msg-group-desc)>0">
    <h3 align="center">Группы извещений и их состав</h3>
     <table border="1" cellpadding="2" align="center">
     <xsl:for-each select="msg-group-desc/group">
        <tr><td>&#160;</td><td align="center">&#160;<b><xsl:value-of select="@id"/>.&#160;<xsl:value-of select="@desc"/></b>
        <xsl:if test="@mask!=''">
        &#160;&#160;(маска группы = 0x<xsl:value-of select="@mask"/>)
        </xsl:if>
        &#160;
        </td></tr>
        <xsl:for-each select="code">
           <tr><td>&#160;<xsl:value-of select="@id"/>&#160;</td><td>&#160;<b><xsl:value-of select="@ademco"/></b>&#160;&#160;<xsl:value-of select="."/>&#160;</td></tr>
        </xsl:for-each>
     </xsl:for-each>
     </table>
     <br/>
  </xsl:if>

  <xsl:if test="$displaylevel>5">
    <h2 align="center">Справочники</h2>

    <xsl:call-template name="handle-desc">
        <xsl:with-param name="elname" select="loop-types-desc"/>
        <xsl:with-param name="hdr" select="'Типы шлейфов'"/>
    </xsl:call-template>

    <xsl:call-template name="handle-desc">
        <xsl:with-param name="elname" select="dpins-types-desc"/>
        <xsl:with-param name="hdr" select="'Типы тамперов'"/>
    </xsl:call-template>

    <xsl:call-template name="handle-desc">
        <xsl:with-param name="elname" select="relay-types-desc"/>
        <xsl:with-param name="hdr" select="'Типы реле'"/>
    </xsl:call-template>

    <xsl:call-template name="handle-desc">
        <xsl:with-param name="elname" select="sms-codes-desc"/>
        <xsl:with-param name="hdr" select="'Кодировка SMS-сообщений'"/>
    </xsl:call-template>

    <xsl:call-template name="handle-desc">
        <xsl:with-param name="elname" select="proto-types-desc"/>
        <xsl:with-param name="hdr" select="'Протоколы'"/>
    </xsl:call-template>

    <xsl:call-template name="handle-desc">
        <xsl:with-param name="elname" select="gsm-switch-desc"/>
        <xsl:with-param name="hdr" select="'Условия смены GSM-оператора'"/>
    </xsl:call-template>

    <!-- Прототипы получателей -->
    <xsl:if test="count(recpt-variant-desc)>0">
        <h3 align="center">Прототипы настройки связи получателей</h3>
        <table border="1" cellpadding="2" cellspacing="2" align="center">
        <tr><td><b>Протоколы</b></td><td align="center"><b>Описание, порядок применения</b></td></tr>
           <xsl:for-each select="recpt-variant-desc/recpt-variant">
            <xsl:if test="@seq!=' '">
            <tr>
            <td align="left"><xsl:value-of select="@seq"/>&#160;</td>
            <td align="left">&#160;<xsl:value-of select="@desc"/></td>
            </tr>
            </xsl:if>
           </xsl:for-each>
        </table>
    </xsl:if>

    <xsl:if test="count(provider-desc)>0">
        <h3 align="center">Операторы мобильной связи</h3>
        <table border="1" cellpadding="2" cellspacing="2" align="center">
        <tr>
            <td align="center"><b>Оператор</b></td><td align="center"><b>APN (access point name)</b></td>
            <td align="center"><b>Имя доступа</b></td><td align="center"><b>Пароль</b></td>
        </tr>
           <xsl:for-each select="provider-desc/provider">
            <tr>
            <td align="left">&#160;<xsl:value-of select="@name"/></td>
            <td align="left">&#160;<xsl:value-of select="@apn"/></td>
            <td align="left">&#160;<xsl:value-of select="@user"/></td>
            <td align="left">&#160;<xsl:value-of select="@pass"/></td>
            </tr>
           </xsl:for-each>
        </table>
    </xsl:if>

  </xsl:if>
</xsl:if>

<xsl:if test="count(cfgwritetime)>0">
<br/>
        <h4 align="center">Дата и время записи в ППКОП: <xsl:value-of select="cfgwritetime"/></h4>
</xsl:if>

<br/>
<hr/>
<div class="copyright" align="center">&#169; 2013, ООО Компания &quot;Проксима&quot;</div>
</BODY>
</HTML>
</xsl:template>

<!-- ======================================================================= -->
<xsl:template name="handle-desc">
  <xsl:param name="elname"/>
  <xsl:param name="hdr"/>
  <xsl:if test="count($elname/code)>0">
    <h3 align="center"><xsl:value-of select="$hdr"/></h3>
    <table border="1" cellpadding="2" cellspacing="2" align="center">
    <tr><td><b>Код</b></td><td align="center"><b>&#160;&#160;Описание&#160;&#160;</b></td></tr>
       <xsl:for-each select="$elname/code">
        <xsl:sort select="@id" data-type="number"/>
        <tr>
        <td align="right"><xsl:value-of select="@id"/>&#160;</td>
        <td align="left">&#160;<xsl:value-of select="."/></td>
        </tr>
       </xsl:for-each>
    </table>
  </xsl:if>
</xsl:template>

<xsl:template name="collect-msg">
   <xsl:for-each select="group">
       <xsl:if test="@use!=''">
         <xsl:variable name="used"><xsl:value-of select="@use"/></xsl:variable>
         <!-- Ищем в шаблонах по id -->
         <xsl:if test="count(//msg-template[@id=$used])>0">
            <xsl:value-of select="//msg-template[@id=$used]/description"/>
         </xsl:if>
         <xsl:if test="count(//msg-template[@id=$used])=0">
            <font color="#ff0000">Нет шаблона &quot;<b><xsl:value-of select="@use"/></b>&quot;</font>
         </xsl:if>
       </xsl:if>
       <xsl:if test="not(@use!='')">
         <!-- Маска или номер извещения -->
         <xsl:if test=".='0x0'">
            Нет извещений для передачи
         </xsl:if>
         <xsl:if test=".!='0x0'">
            <xsl:value-of select="."/>
         </xsl:if>
       </xsl:if>
       <xsl:if test="position() &lt; last()">;&#160;</xsl:if>
   </xsl:for-each>
</xsl:template>

<xsl:template name="get-gsm-switch">
  <xsl:param name="type"/>
    <xsl:value-of select="//gsm-switch-desc/code[@id=$type]"/>
</xsl:template>

<xsl:template name="get-loop-type">
  <xsl:param name="type"/>
  <xsl:param name="subtype"/>
    <xsl:value-of select="//loop-types-desc/code[@id=$type]"/>
    &#160;<xsl:value-of select="//classtypes-desc/code[@id=$subtype]"/>
</xsl:template>

<xsl:template name="get-dpin-type">
  <xsl:param name="type"/>
    <xsl:value-of select="//dpins-types-desc/code[@id=$type]"/>
</xsl:template>

<xsl:template name="get-sreg-desc">
  <xsl:param name="type"/>
    <xsl:value-of select="//sreg-desc/code[@id=$type]"/>
</xsl:template>

<xsl:template name="get-proto-type">
  <xsl:param name="type"/>
    <b><xsl:value-of select="//proto-types-desc/code[@id=$type]"/></b>
</xsl:template>

<xsl:template name="get-sms-code">
  <xsl:param name="type"/>
    <b><xsl:value-of select="//sms-codes-desc/code[@id=$type]"/></b>
</xsl:template>

<xsl:template name="get-relay-type">
  <xsl:param name="type"/>
    <xsl:value-of select="//relay-types-desc/code[@id=$type]"/>
</xsl:template>

<!-- Единицы измерителя -> сопротивление -->
<xsl:template name="calc_resistance">
  <xsl:param name="res"/>
  <xsl:if test="$resistance-mode=1">
    <xsl:value-of select="format-number($res div 100,'###0.0')"/>
  </xsl:if>
</xsl:template>

<!-- Для подстановки в таблицу -->
<xsl:template name="table_resistance">
  <xsl:param name="txt"/>
  <xsl:param name="res"/>
  <tr>
  <td align="left"><xsl:value-of select="$txt"/>, <xsl:value-of select="$resname"/></td>
  <td align="right">
     <xsl:call-template name="calc_resistance">
         <xsl:with-param name="res" select="$res"/>
     </xsl:call-template>
  </td>
  </tr>
</xsl:template>

<!-- Для подстановки в текст -->
<xsl:template name="text_resistance">
  <xsl:param name="txt"/>
  <xsl:param name="res"/>
  <br/>&#160;&#160;&#160;&#160;<xsl:value-of select="$txt"/> -
  <xsl:call-template name="calc_resistance">
      <xsl:with-param name="res" select="$res"/>
  </xsl:call-template>
  &#160;<xsl:value-of select="$resname"/>
</xsl:template>

<xsl:template name="loop-fulldesc">
    <p align="left">
    <xsl:if test="count(@tampertype)=0">
        <b>&#160;
        Шлейф <xsl:value-of select="@id"/>&#160;
        <xsl:if test="@devid!=''">
            (<xsl:value-of select="@devid"/>)&#160;
        </xsl:if>
        тип&#160;<xsl:value-of select="@type"/>
        <xsl:if test="$withpartition!=''">
            <xsl:if test="@type!=11 and @type!=14"><xsl:if test="@partition!=''">, раздел <xsl:value-of select="@partition"/></xsl:if></xsl:if>
        </xsl:if>&#160;-
        <xsl:call-template name="get-loop-type">
            <xsl:with-param name="type" select="@type"/>
            <xsl:with-param name="subtype" select="@subtype"/>
        </xsl:call-template>
        <xsl:if test="@passthrough='Y'">&#160;&#160;(проходная зона)</xsl:if>
        </b>
        <xsl:if test="count(description)>0">
            &#160;&#160;<font color="#0000ff"><xsl:value-of select="description"/></font>
        </xsl:if>
        <xsl:if test="@type!=8">
          <xsl:if test="@armonly='Y'"><br/>&#160;&#160;&#160;&#160;<font color="#ff0000"><b>Связанные разделы (шлейфы) берутся под охрану, но не снимаются с охраны!</b></font></xsl:if>
          
          <xsl:if test="@autotake='Y'"><br/>&#160;&#160;&#160;&#160;Шлейф берется под охрану при возникновении тревоги</xsl:if>
          <xsl:if test="@skip='Y'"><br/>&#160;&#160;&#160;&#160;<font color="#ff0000"><b>Внимание! Этот шлейф или расширитель исключен из разделов и игнорируется при взятии под охрану.</b></font></xsl:if>
          <xsl:if test="@autobypass='Y'"><br/>&#160;&#160;&#160;&#160;При взятии под охрану разрешен автоматический обход не готового шлейфа</xsl:if>
          <xsl:if test="@autorestore='Y'"><br/>&#160;&#160;&#160;&#160;Шлейф автоматически берется под охрану при восстановлении нормального сопротивления</xsl:if>
          <xsl:if test="@fire-reset='Y'"><br/>&#160;&#160;&#160;&#160;Пожарный шлейф сбрасывается отключением питания</xsl:if>
          <xsl:if test="@alarm-on-2b='Y'"><br/>&#160;&#160;&#160;&#160;Тревога при двойной сработке шлейфа</xsl:if>
          <xsl:if test="count(@num-fire-sensors)>0"><br/>&#160;&#160;&#160;&#160;Пожарных зон:&#160;<b><xsl:value-of select="@num-fire-sensors"/></b><xsl:if test="@type=11 or @type=14">, раздел <b><xsl:value-of select="@partition"/></b></xsl:if></xsl:if>
          <xsl:if test="count(@num-guard-sensors)>0"><br/>&#160;&#160;&#160;&#160;Охранных зон:&#160;<b><xsl:value-of select="@num-guard-sensors"/></b>, раздел <b><xsl:value-of select="@partition + 1"/></b></xsl:if>
          <br/>
          <xsl:if test="count(@net-id)>0">&#160;&#160;&#160;&#160;Номер сети:&#160;<b><xsl:value-of select="@net-id"/></b></xsl:if>
          <xsl:if test="count(@radio-period)>0">&#160;&#160;&#160;&#160;Периодичность выхода в эфир:&#160;<b><xsl:value-of select="@radio-period"/></b></xsl:if>
          <xsl:if test="count(@freq-id)>0">&#160;&#160;&#160;&#160;Частотная литера, основная и резервная частоты:&#160;<b><xsl:value-of select="@freq-id"/></b></xsl:if>
        </xsl:if>
        <xsl:if test="@lock3b='Y'"><br/>&#160;&#160;&#160;&#160;Если тревога возникает 3 и более раз подряд, извещения тревоги не передавать</xsl:if>

        <xsl:if test="$displaylevel>3">
            <!-- Индивидуальные настройки шлейфа -->
            <xsl:if test="@type=8">
                <xsl:if test="count(@ctlrelay)>0">
                    <xsl:if test="@ctlrelay>0">
                        <br/>&#160;&#160;&#160;&#160;Цепь оповещения подключена к реле
                        <xsl:value-of select="@ctlrelay"/>
                    </xsl:if>
                </xsl:if>
                
                <br/>&#160;&#160;&#160;&#160;Контролируемое напряжение, В:
                &#160;&#160;мин.<xsl:value-of select="format-number(lowlevel div 1000,'##0.00')"/>
                &#160;&#160;&#160;макс.<xsl:value-of select="format-number(highlevel div 1000,'##0.00')"/>

                <xsl:if test="count(breaktime)>0">
                    <br/>&#160;&#160;&#160;&#160;Время срабатывания -
                <xsl:value-of select="breaktime"/> мсек
                </xsl:if>
                <xsl:if test="count(restoretime)>0">
                    <br/>&#160;&#160;&#160;&#160;Время восстановления после тревоги -
                    <xsl:if test="restoretime &lt; 1001">
                        <xsl:value-of select="restoretime * 50"/> мсек
                    </xsl:if>
                    <xsl:if test="restoretime &gt; 1000">
                        <xsl:value-of select="format-number(restoretime div 20,'#######0.00')"/> сек
                    </xsl:if>
                </xsl:if>
            </xsl:if>

            <xsl:if test="@type &gt; 1 and @type &lt; 7 or @type = 10">
                <xsl:if test="count(lowlevel)>0">
                    <xsl:call-template name="text_resistance">
                        <xsl:with-param name="txt" select="'Минимально допустимое сопротивление шлейфа с учетом 10% точности'"/>
                        <xsl:with-param name="res" select="lowlevel"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="count(highlevel)>0">
                    <xsl:call-template name="text_resistance">
                        <xsl:with-param name="txt" select="'Максимально допустимое сопротивление шлейфа с учетом 10% точности'"/>
                        <xsl:with-param name="res" select="highlevel"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="count(breaktime)>0">
                    <br/>&#160;&#160;&#160;&#160;Время констатации нарушения шлейфа -
                <xsl:value-of select="breaktime"/> мсек
                </xsl:if>
                <xsl:if test="count(restoretime)>0">
                    <br/>&#160;&#160;&#160;&#160;Время констатации восстановления нормального сопротивления шлейфа после тревоги -
                    <xsl:if test="restoretime &lt; 1001">
                        <xsl:value-of select="restoretime * 50"/> мсек
                    </xsl:if>
                    <xsl:if test="restoretime &gt; 1000">
                        <xsl:value-of select="format-number(restoretime div 20,'#######0.00')"/> сек
                    </xsl:if>
                </xsl:if>
                <xsl:if test="count(drift)+count(slowdrift)>0">
                    <br/>
                    <xsl:if test="count(drift)>0">
                        &#160;&#160;&#160;&#160;
                        Допустимый дрейф&#160;&#160;<xsl:value-of select="drift"/>%
                    </xsl:if>
                    <!-- xsl:if test="count(slowdrift)>0">
                       &#160;&#160;&#160;&#160;
                        Медленный дрейф&#160;&#160;<xsl:value-of select="slowdrift"/>%
                    </xsl:if -->
                </xsl:if>
            </xsl:if>
            <xsl:if test="@type=2 or @type=11 or @type=14">
                <xsl:if test="count(delay-for-out)>0">
                    <br/>&#160;&#160;&#160;&#160;Время задержки на выход - <b><xsl:value-of select="delay-for-out"/></b> сек
                </xsl:if>
                <xsl:if test="count(delay-for-in)>0">
                    <br/>&#160;&#160;&#160;&#160;Время задержки на вход - <b><xsl:value-of select="delay-for-in"/></b> сек
                </xsl:if>
                <xsl:if test="count(pe-zone)>0">
                    <br/>&#160;&#160;&#160;&#160;Зоны входа/выхода - <b><xsl:value-of select="pe-zone/@e1"/>
                    <xsl:if test="count(pe-zone/@e2)>0">, <xsl:value-of select="pe-zone/@e2"/></xsl:if></b>
                    <xsl:if test="count(pe-zone/@p1)>0">
                        <br/>&#160;&#160;&#160;&#160;Проходные зоны - <b><xsl:value-of select="pe-zone/@p1"/>
                        <xsl:if test="count(pe-zone/@p2)>0">, <xsl:value-of select="pe-zone/@p2"/></xsl:if></b>
                    </xsl:if>
                </xsl:if>
                <xsl:if test="count(panic-zone)>0">
                  <br/>&#160;&#160;&#160;&#160;Зоны тревожных кнопок:<b>
                    <xsl:for-each select="panic-zone">
                        <xsl:sort select="@id" data-type="number"/>&#160;&#160;<xsl:value-of select="@id"/>.
                    </xsl:for-each>
                  </b>
                </xsl:if>
            </xsl:if>
        </xsl:if>

        <xsl:if test="@type=7">
            <xsl:if test="loops-on/@partition!=''">
            <br/>&#160;&#160;&#160;&#160;
                При замыкании под охрану берутся разделы - <xsl:value-of select="loops-on/@partition"/>
            </xsl:if>
            
           <xsl:if test="loops-off/@partition!=''">
           <br/>&#160;&#160;&#160;&#160;
               При размыкании с охраны снимаются разделы - <xsl:value-of select="loops-off/@partition"/>
           </xsl:if>
        </xsl:if>

        <xsl:if test="count(own-msg)>0">
            <br/>&#160;&#160;<b>Индивидуальные SMS-сообщения:</b><br/>
            <xsl:for-each select="own-msg">
                <xsl:sort select="@id" data-type="number"/>
                &#160;&#160;&#160;&#160;<xsl:value-of select="@id"/>. <xsl:value-of select="."/>
                <br/>
            </xsl:for-each>
        </xsl:if>

    </xsl:if>
    <xsl:if test="count(@tampertype)>0">
        <b>&#160;
        &#160;Тампер <xsl:value-of select="@id"/>
        &#160;
        <font color="#0000ff"><xsl:value-of select="description"/></font>
        &#160;тип&#160;<xsl:call-template name="get-dpin-type">
           <xsl:with-param name="type" select="@tampertype"/>
        </xsl:call-template>
        </b>

        <xsl:if test="count(own-msg)>0">
            <br/>&#160;&#160;<b>Индивидуальные SMS-сообщения:</b><br/>
            <xsl:for-each select="own-msg">
                <xsl:sort select="@id" data-type="number"/>
                &#160;&#160;&#160;&#160;<xsl:value-of select="@id"/>. <xsl:value-of select="."/>
                <br/>
            </xsl:for-each>
        </xsl:if>
    </xsl:if>
    </p>
</xsl:template>

<xsl:template name="dpin-fulldesc">
    <p align="left">
    <b>&#160;
    Тампер <xsl:value-of select="@id"/>
    <xsl:if test="@devid!=''">
        (<xsl:value-of select="@devid"/>)&#160;
    </xsl:if>
    тип&#160;<xsl:value-of select="@type"/>&#160;-
       <xsl:call-template name="get-dpin-type">
           <xsl:with-param name="type" select="@type"/>
       </xsl:call-template>
    </b>
    <xsl:if test="count(description)>0">
        &#160;&#160;<font color="#0000ff"><xsl:value-of select="description"/></font>
    </xsl:if>

        &#160;&#160;&#160;&#160;<xsl:if test="@partition!=''">Связанные разделы - <xsl:value-of select="@partition"/></xsl:if>
        <xsl:if test="@armonly='Y'">&#160;&#160;<font color="#ff0000"><b>(берутся под охрану, но не снимаются с охраны)</b></font></xsl:if>

    <xsl:if test="count(own-msg)>0">
        <br/>&#160;&#160;<b>Индивидуальные SMS-сообщения:</b><br/>
        <xsl:for-each select="own-msg">
            <xsl:sort select="@id" data-type="number"/>
            &#160;&#160;&#160;&#160;<xsl:value-of select="@id"/>. <xsl:value-of select="."/>
            <br/>
        </xsl:for-each>
    </xsl:if>
    </p>
</xsl:template>

</xsl:stylesheet>
